import json

def find_items_with_null(file_path):
    with open(file_path, 'r', encoding='utf-8') as file:
        item_ids_with_null = []
        for line in file:
            item = json.loads(line.strip())
            if item.get('scores', {}).get('style') is None or \
               item.get('scores', {}).get('engaging') is None or \
               item.get('scores', {}).get('coherence') is None:
                item_ids_with_null.append(item['item_id'])
        
        return item_ids_with_null
    
file_path = './output_final.jsonl'

item_ids = find_items_with_null(file_path)

# Print the resutls
print("Items with null values in any field:", item_ids)
